﻿using System;
using System.Collections.Generic;
using System.Numerics; // Konieczne do możliwości użycia klasy BigInteger.

namespace InfiniteSequence
{
    class Program
    {
        // Listing 7-36. Sekwencja nieskończona.
        static IEnumerable<BigInteger> Fibonacci()
        {
            BigInteger current = 1;
            BigInteger previous = 1;
            yield return 1;
            while (true)
            {
                yield return current;
                BigInteger next = current + previous;
                previous = current;
                current = next;
            }
        }

        static void Main(string[] args)
        {
            foreach (BigInteger number in Fibonacci())
            {
                Console.WriteLine(number);
            }
        }
    }
}
